/*
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.feature.ucl.services;

import com.sap.cds.CdsData;
import com.sap.cds.Struct;
import java.util.Map;

/**
 * A tenant in the payload provided by UCL. It can be either the receiver or the assigned tenant of
 * a formation assignment notification.
 */
public interface SpiiTenant extends CdsData {

  static SpiiTenant create() {
    return Struct.create(SpiiTenant.class);
  }

  String getState();

  String getUclAssignmentId();

  String getDeploymentRegion();

  String getApplicationNamespace();

  String getApplicationUrl();

  String getApplicationTenantId();

  String getSubaccountId();

  String getSubdomain();

  String getUclSystemName();

  String getUclSystemTenantId();

  Map<String, Object> getParameters();

  Map<String, Object> getConfiguration();
}
