/*
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.feature.ucl.services;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;

@EventName(UclService.EVENT_UNASSIGN)
public interface UnassignEventContext extends EventContext {

  /**
   * Creates an {@link EventContext} already overlayed with this interface. The event is set to be
   * {@link UclService#EVENT_UNASSIGN}
   *
   * @return the {@link UnassignEventContext}
   */
  static UnassignEventContext create() {
    return EventContext.create(UnassignEventContext.class, null);
  }

  @Override
  UclService getService();

  /**
   * @return the tenant ID
   */
  String getTenant();

  /**
   * Sets the tenant ID
   *
   * @param tenant the tenant ID
   */
  void setTenant(String tenant);

  /**
   * Returns the `context` node of the payload provided by UCL which includes metadata of the
   * formation assignment notification.
   *
   * @return the `context` node of the payload
   */
  SpiiContext getUclContext();

  /**
   * Sets the `context` node of the formation assignment notification.
   *
   * @param spiiContext the `context` node
   */
  void setUclContext(SpiiContext spiiContext);

  /**
   * Returns an instance {@link SpiiTenant} representing the assigned tenant of the formation
   * assignment notification.
   *
   * @return the assigned tenant
   */
  SpiiTenant getUclAssignedTenant();

  /**
   * Sets the assigned tenant of the formation assignment notification.
   *
   * @param uclAssignedTenant the assigned tenant
   */
  void setUclAssignedTenant(SpiiTenant uclAssignedTenant);

  /**
   * Returns an instance {@link SpiiTenant} representing the receiver tenant of the formation
   * assignment notification.
   *
   * @return the assigned tenant
   */
  SpiiTenant getUclReceiverTenant();

  /**
   * Sets the receiver tenant of the formation assignment notification.
   *
   * @param uclReceiverTenant the receiver tenant
   */
  void setUclReceiverTenant(SpiiTenant uclReceiverTenant);
}
