/*
 * © 2024-2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.feature.ucl.services.impl;

import com.sap.cds.feature.ucl.services.AssignEventContext;
import com.sap.cds.feature.ucl.services.SpiiContext;
import com.sap.cds.feature.ucl.services.SpiiResult;
import com.sap.cds.feature.ucl.services.SpiiTenant;
import com.sap.cds.feature.ucl.services.UclService;
import com.sap.cds.feature.ucl.services.UnassignEventContext;
import com.sap.cds.services.ServiceDelegator;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.utils.OrderConstants;

public class UclServiceImpl extends ServiceDelegator implements UclService {

  public UclServiceImpl(String name) {
    super(name);
  }

  @Override
  public SpiiResult assign(
      String tenantId, SpiiContext context, SpiiTenant receiverTenant, SpiiTenant assignedTenant) {
    AssignEventContext ctx = AssignEventContext.create();
    ctx.setTenant(tenantId);
    ctx.setUclContext(context);
    ctx.setUclAssignedTenant(assignedTenant);
    ctx.setUclReceiverTenant(receiverTenant);
    emit(ctx);
    return ctx.getResult();
  }

  @Override
  public void unassign(
      String tenantId, SpiiContext context, SpiiTenant receiverTenant, SpiiTenant assignedTenant) {
    UnassignEventContext ctx = UnassignEventContext.create();
    ctx.setTenant(tenantId);
    ctx.setUclContext(context);
    ctx.setUclAssignedTenant(assignedTenant);
    ctx.setUclReceiverTenant(receiverTenant);
    emit(ctx);
  }

  @On
  @HandlerOrder(OrderConstants.On.DEFAULT_ON)
  private void defaultAssign(AssignEventContext context) {
    SpiiResult result = SpiiResult.create();
    result.setReady(true);
    context.setResult(result);
  }

  @On
  @HandlerOrder(OrderConstants.On.DEFAULT_ON)
  private void defaultUnassign(UnassignEventContext context) {
    context.setCompleted();
  }
}
