/*
 * © 2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.feature.ucl;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.sap.cds.integration.cloudsdk.rest.client.JsonRestClient;
import java.io.IOException;
import java.util.Map;

public class UclClient extends JsonRestClient {

  public UclClient(String destinationName) {
    // destination must only be picked up from the provider account for security reasons
    super(destinationName, "AlwaysProvider");
  }

  public void callbackTenantMapping(String url, Map<String, Object> body) throws IOException {
    patchRequestWithOnlyResponseCode(url, mapper.convertValue(body, ObjectNode.class));
  }
}
