/*
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.feature.ucl.adapter;

import com.sap.cds.CdsData;
import com.sap.cds.Struct;
import com.sap.cds.feature.ucl.services.SpiiContext;
import com.sap.cds.feature.ucl.services.SpiiTenant;
import java.util.Map;

/** Request payload of an incoming UCL request. */
public interface SpiiRequest extends CdsData {

  static SpiiRequest create() {
    return Struct.create(SpiiRequest.class);
  }

  static SpiiRequest of(Map<String, Object> attributes) {
    return Struct.access(attributes).as(SpiiRequest.class);
  }

  SpiiContext getContext();

  SpiiTenant getReceiverTenant();

  SpiiTenant getAssignedTenant();
}
