/*
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.feature.ucl.services;

import com.sap.cds.CdsData;
import com.sap.cds.Struct;
import java.util.Map;

/** Result of a formation assignment notification event (see {@link UclService#EVENT_ASSIGN}. */
public interface SpiiResult extends CdsData {

  static SpiiResult create() {
    return Struct.create(SpiiResult.class);
  }

  /**
   * Configuration that should be provided to the assigned UCL tenant.
   *
   * @return the configuration
   */
  Map<String, Object> getConfiguration();

  void setConfiguration(Map<String, Object> configuration);

  /**
   * Flag which indicates if the assignment of the receiver tenant was successful.
   *
   * @return {@code true} if the assignment was successful, {@code false} if additional
   *     configuration from the assigned tenant is required.
   */
  Boolean getReady();

  void setReady(Boolean ready);
}
