/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.xsuaa;

import com.sap.cds.feature.xsuaa.XsUaaToken;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.authentication.AuthenticationInfo;
import com.sap.cds.services.authentication.JwtTokenAuthenticationInfo;
import com.sap.cds.services.environment.ServiceBinding;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.UserInfoProvider;
import com.sap.cds.services.utils.ClassMethods;
import com.sap.cds.services.utils.ErrorStatusException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XsuaaUserInfoProvider
implements UserInfoProvider {
    private static final Logger logger = LoggerFactory.getLogger(XsuaaUserInfoProvider.class);
    private final ServiceBinding uaaInstance;
    private final CdsRuntime runtime;

    public XsuaaUserInfoProvider(ServiceBinding uaaInstance, CdsRuntime runtime) {
        this.uaaInstance = uaaInstance;
        this.runtime = runtime;
    }

    public UserInfo get() {
        AuthenticationInfo authenticationInfo = this.runtime.getProvidedAuthenticationInfo();
        if (authenticationInfo instanceof JwtTokenAuthenticationInfo) {
            try {
                JwtTokenAuthenticationInfo accessToken = (JwtTokenAuthenticationInfo)authenticationInfo;
                XsUaaToken jwt = XsUaaToken.parse(accessToken.getToken());
                logger.debug("Decoded XSUAA JWT token: {}", (Object)jwt.toString());
                return new XsuaaUserInfoImpl(jwt);
            }
            catch (ServiceException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ErrorStatusException((ErrorStatus)ErrorStatuses.UNAUTHORIZED, new Object[]{e});
            }
        }
        return null;
    }

    private class XsuaaUserInfoImpl
    implements UserInfo {
        private final XsUaaToken jwt;
        private final String name;
        private final boolean isSystemUser;
        private final Set<String> roles;
        private final Map<String, List<String>> attributes;
        private final Set<String> unrestrictedAttributes;
        private static final String SPECIAL_ATTRIBUTE_TENANT = "tenant";
        private static final String EXTENSION_ATTRIBUTES = "ext_attr";
        private static final String SERVICEINSTANCEID_ATTRIBUTE = "serviceinstanceid";
        private static final String SPECIAL_ATTRIBUTE_SERVICEINSTANCEID = "ext_attr.serviceinstanceid";
        private static final String UnrestrictedAttribute = "$unrestricted";
        private static final String SystemUserName = "system";

        private XsuaaUserInfoImpl(XsUaaToken jwt) {
            this.jwt = jwt;
            boolean bl = this.isSystemUser = jwt.getGrantType() != null && (jwt.getGrantType().equals(XsUaaToken.GrantType.CLIENT_CREDENTIALS.toString()) || jwt.getGrantType().equals(XsUaaToken.GrantType.CLIENT_X509.toString()));
            if (this.isSystemUser) {
                this.name = SystemUserName;
            } else {
                String normalizedName = jwt.getName();
                if (normalizedName != null && XsuaaUserInfoProvider.this.runtime.getEnvironment().getCdsProperties().getSecurity().getXsuaa().isNormalizeUserNames()) {
                    normalizedName = jwt.getName().trim().toLowerCase(Locale.ENGLISH);
                }
                this.name = normalizedName;
            }
            String scopePrefix = (String)XsuaaUserInfoProvider.this.uaaInstance.getCredentials().get("xsappname") + ".";
            this.roles = jwt.getScopes().stream().map(scope -> {
                int pos = scope.indexOf(scopePrefix);
                if (pos >= 0) {
                    return scope.substring(pos + scopePrefix.length());
                }
                return scope;
            }).collect(Collectors.toSet());
            this.attributes = new TreeMap<String, List<String>>();
            this.unrestrictedAttributes = new TreeSet<String>();
            for (Map.Entry<String, List<String>> userAttribute : jwt.getUserAttributes().entrySet()) {
                List<String> attributeValues = userAttribute.getValue();
                if (attributeValues == null) continue;
                ArrayList<String> valuesRaw = new ArrayList<String>(attributeValues);
                int valuesRawSize = valuesRaw.size();
                valuesRaw.removeIf(UnrestrictedAttribute::equalsIgnoreCase);
                if (valuesRaw.size() != valuesRawSize) {
                    this.unrestrictedAttributes.add(userAttribute.getKey());
                }
                this.attributes.put(userAttribute.getKey(), valuesRaw);
            }
            this.attributes.put(SPECIAL_ATTRIBUTE_TENANT, Collections.singletonList(jwt.getTenant()));
            Object serviceInstanceId = jwt.getExtensionAttributes().get(SERVICEINSTANCEID_ATTRIBUTE);
            if (serviceInstanceId != null && serviceInstanceId instanceof String) {
                this.attributes.put(SPECIAL_ATTRIBUTE_SERVICEINSTANCEID, Collections.singletonList((String)serviceInstanceId));
            }
        }

        public String getId() {
            return this.jwt.getId();
        }

        public String getName() {
            return this.name;
        }

        public String getTenant() {
            return this.jwt.getTenant();
        }

        public Set<String> getRoles() {
            return this.roles;
        }

        public boolean isSystemUser() {
            return this.isSystemUser;
        }

        public boolean isAuthenticated() {
            return true;
        }

        public boolean isPrivileged() {
            return false;
        }

        public Map<String, List<String>> getAttributes() {
            return this.attributes;
        }

        public Map<String, Object> getAdditionalAttributes() {
            return this.jwt.getAdditionalAttributes();
        }

        public Set<String> getUnrestrictedAttributes() {
            return this.unrestrictedAttributes;
        }

        public <T extends UserInfo> T as(Class<T> userInfoClazz) {
            return (T)((UserInfo)ClassMethods.as(userInfoClazz, UserInfo.class, (Object)this, this::getAdditionalAttributes));
        }
    }
}

