/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.xsuaa;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class XsUaaToken {
    private static final String BEARER_TOKEN = "bearer";
    private static final String CLAIM_GIVEN_NAME = "given_name";
    private static final String CLAIM_FAMILY_NAME = "family_name";
    private static final String CLAIM_ZDN = "zdn";
    private String id;
    private String tenant;
    private String grantType;
    @JsonProperty(value="user_name")
    private String name;
    @JsonProperty(value="scope")
    private List<String> scopes = new ArrayList<String>();
    @JsonProperty(value="client_id")
    private String clientId;
    @JsonProperty(value="xs.user.attributes")
    private Map<String, List<String>> userAttributes = new HashMap<String, List<String>>();
    @JsonProperty(value="xs.system.attributes")
    private Map<String, List<String>> systemAttributes = new HashMap<String, List<String>>();
    @JsonProperty(value="ext_attr")
    private Map<String, Object> extendedAttributes = new HashMap<String, Object>();
    @JsonAnySetter
    private Map<String, Object> additionalAttributes = new HashMap<String, Object>();
    private static ObjectMapper jsonMapper = XsUaaToken.createObjectMapper();

    private XsUaaToken(@JsonProperty(value="user_id", required=false) String id, @JsonProperty(value="zid", required=true) String zid, @JsonProperty(value="grant_type", required=true) String grantType) {
        this.id = id;
        this.tenant = zid;
        this.grantType = grantType;
    }

    public static XsUaaToken parse(String authorizationHeader) {
        XsUaaToken decodedJwtToken = XsUaaToken.decodeJwtToken(authorizationHeader);
        decodedJwtToken.initComputedAttributes();
        return decodedJwtToken;
    }

    private void initComputedAttributes() {
        this.additionalAttributes.put("ext_attr", this.extendedAttributes);
        String givenName = this.tryCastString(this.getExtensionAttributes().get(CLAIM_GIVEN_NAME));
        if (givenName == null) {
            givenName = this.tryCastString(this.additionalAttributes.get(CLAIM_GIVEN_NAME));
        }
        this.additionalAttributes.put("givenName", givenName);
        String familyName = this.tryCastString(this.getExtensionAttributes().get(CLAIM_FAMILY_NAME));
        if (familyName == null) {
            familyName = this.tryCastString(this.additionalAttributes.get(CLAIM_FAMILY_NAME));
        }
        this.additionalAttributes.put("familyName", familyName);
        String subDomain = this.tryCastString(this.getExtensionAttributes().get(CLAIM_ZDN));
        this.additionalAttributes.put("subDomain", subDomain);
    }

    private String tryCastString(Object value) {
        String s;
        return value instanceof String ? (s = (String)value) : null;
    }

    private static XsUaaToken decodeJwtToken(String authorizationHeader) {
        String[] jwtParts;
        String jwtRaw = authorizationHeader.trim();
        if (jwtRaw.substring(0, Math.min(BEARER_TOKEN.length(), authorizationHeader.length() - 1)).toLowerCase(Locale.ENGLISH).equals(BEARER_TOKEN)) {
            jwtRaw = jwtRaw.substring(BEARER_TOKEN.length());
            jwtRaw = jwtRaw.trim();
        }
        if ((jwtParts = jwtRaw.split("\\.")).length == 3) {
            String base64EncodedBody = jwtParts[1];
            String jwtInfo = new String(Base64.getUrlDecoder().decode(base64EncodedBody));
            try {
                return (XsUaaToken)jsonMapper.readValue(jwtInfo, XsUaaToken.class);
            }
            catch (Exception e) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.TOKEN_PARSING_FAILED, new Object[]{e});
            }
        }
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.TOKEN_PARSING_FAILED, new Object[0]);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getGrantType() {
        return this.grantType;
    }

    public String getClientId() {
        return this.clientId;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public Map<String, List<String>> getUserAttributes() {
        return this.userAttributes;
    }

    public Map<String, List<String>> getSystemAttributes() {
        return this.systemAttributes;
    }

    public Map<String, Object> getExtensionAttributes() {
        return this.extendedAttributes;
    }

    public Map<String, Object> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    public String toString() {
        try {
            return jsonMapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            return "<Failed to convert to JSON string>";
        }
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return mapper;
    }

    public static enum GrantType {
        CLIENT_CREDENTIALS("client_credentials"),
        CLIENT_X509("client_x509");

        public final String id;

        private GrantType(String id) {
            this.id = id;
        }

        public String toString() {
            return this.id;
        }
    }
}

