/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.feature.xsuaa;

import java.util.function.Consumer;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.sap.cds.services.runtime.CdsRuntimeConfiguration;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;
import com.sap.cds.services.utils.XsuaaUtils;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;

public class XsuaaConfiguration implements CdsRuntimeConfiguration {

	private static final Logger logger = LoggerFactory.getLogger(XsuaaConfiguration.class);

	@Override
	public void eventHandlers(CdsRuntimeConfigurer configurer) {
		xsuaaConfigured(configurer, binding -> {
			configurer.eventHandler(new XsuaaTenantProviderHandler(binding));
		});
	}

	@Override
	public void providers(CdsRuntimeConfigurer configurer) {
		xsuaaConfigured(configurer, binding -> {
			logger.info("Loaded feature 'XsuaaUserInfoProvider' ({})", binding.getName().get());
			configurer.provider(new XsuaaUserInfoProvider(binding, configurer.getCdsRuntime()));
		});
	}

	private void xsuaaConfigured(CdsRuntimeConfigurer configurer, Consumer<ServiceBinding> configure) {
		XsuaaUtils xsuaaUtils = new XsuaaUtils(configurer.getCdsRuntime());
		if (xsuaaUtils.xsuaaAuthenticationConfigured()) {
			xsuaaUtils.getXsuaaServiceBindings().stream().findFirst().ifPresent(configure);
		}
	}

}
