package com.sap.cds.feature.xsuaa;

import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.mt.ReadProviderTenantEventContext;
import com.sap.cds.services.mt.TenantProviderService;
import com.sap.cds.services.utils.OrderConstants;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;

@ServiceName(value = TenantProviderService.DEFAULT_NAME, type = TenantProviderService.class)
public class XsuaaTenantProviderHandler implements EventHandler {

	private final static String KEY_PROVIDER_TENANT_ID = "tenantid";
	private final String providerTenant;

	public XsuaaTenantProviderHandler(ServiceBinding binding) {
		providerTenant = (String) binding.getCredentials().get(KEY_PROVIDER_TENANT_ID);
	}

	@On
	@HandlerOrder(OrderConstants.On.FEATURE)
	public void readProviderTenant(ReadProviderTenantEventContext context) {
		if (providerTenant != null) {
			context.setResult(providerTenant);
		}
	}

}
