/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.feature.xsuaa;

import com.sap.cds.services.request.UserInfo;

/**
 * This interface extends the common  {@link UserInfo} with XSUAA specific getters.
 * <p>
 * Given a {@code UserInfo} instance {@code userInfo} you can obtain an instance of {@code XsuaaUserInfo}
 * by calling {@code userInfo.as(XsuaaUserInfo.class)}.
 */
public interface XsuaaUserInfo extends UserInfo {

	/**
	 * Returns the email of the user if present.
	 *
	 * @return The email if present.
	 */
	String getEmail();

	/**
	 * Returns the user origin. i.e. the user store the user comes from.
	 * Platform users have origin "uaa".
	 * <p>
	 * Might be {@code null} in case this JWT was not created with OAuth 2.0 client
	 * credentials flow.
	 *
	 * @return the user origin if present.
	 */
	String getOrigin();

	/**
	 * Returns the given name of the user if present.
	 * {@code ext_attr.given_name} claim takes precedence before {@code given_name} claim.
	 *
	 * @return the given name if present.
	 */
	String getGivenName();

	/**
	 * Returns the family name of the user if present.
	 * {@code ext_attr.family_name} claim takes precedence before {@code family_name} claim.
	 *
	 * @return the given name if present.
	 */
	String getFamilyName();

	/**
	 * Returns the subdomain of the user's tenant.
	 *
	 * @return the subdomain of the tenant.
	 */
	String getSubDomain();
}
