/**************************************************************************
 * (C) 2019-2020 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.framework.spring.actuator;

import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

import com.sap.cds.feature.config.Properties;
import com.sap.cds.feature.mt.MtFeatureConditions;

/**
 * This health check is not configured if MT is inactive (runtime conditions are not met)
 * or db health check is deactivated by profile.
 */
class DbHealthCheckMtCondition implements Condition {

	@Override
	public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
		return Properties.getCds().getMultiTenancy().getHealthCheck().isEnabled() &&
				MtFeatureConditions.unmetCondition() == null;	// mt is enabled generally
	}

}