/**************************************************************************
 * (C) 2019-2020 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.framework.spring.actuator;

import javax.sql.DataSource;

import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.jdbc.DataSourceHealthContributorAutoConfiguration;
import org.springframework.boot.actuate.health.HealthContributor;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

import com.sap.cds.feature.mt.MtFeatureConditions;


/**
 * Configuration which overrides the standard Spring db health check in MT scenario.
 */
@Configuration
@ConditionalOnClass({HealthIndicator.class, MtFeatureConditions.class}) // spring-actuator + cds-features-mt must be in classpath
@ConditionalOnBean(DataSource.class) // a datasource bean must exist
@ConditionalOnEnabledHealthIndicator("db")
@Conditional(DbHealthCheckMtCondition.class)
@AutoConfigureAfter(DataSourceAutoConfiguration.class)
@AutoConfigureBefore(DataSourceHealthContributorAutoConfiguration.class)
public class DbHealthIndicatorMtConfig {

	@Bean("dbHealthIndicator") // this will ensure to override the bean from DataSourceHealthContributorAutoConfiguration
	public HealthContributor dbHealthIndicatorMt(DataSource dataSource) {
		return new DbHealthIndicatorMt(dataSource);
	}

}
