/**************************************************************************
 * (C) 2019-2020 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.framework.spring.config.runtime;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

import com.sap.cds.services.application.ApplicationLifecycleService;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;

@Component
public class ApplicationStartedListener implements ApplicationListener<ApplicationReadyEvent> {

	@Autowired
	private CdsRuntimeConfigurer configurer;

	@Override
	public void onApplicationEvent(ApplicationReadyEvent applicationReadyEvent) {
		if(!isValidContext(applicationReadyEvent.getApplicationContext())) return;

		// fire application started event - web server is up and running
		configurer.getCdsRuntime().getServiceCatalog().getServices(ApplicationLifecycleService.class).forEach(as -> as.applicationStarted());
	}

	/**
	 * Checks that this event is fired on the context, that contains the CdsRuntimeConfigurer
	 * @param context the ApplicationContext
	 * @return true, if the context contains the CdsRuntimeConfigurer
	 */
	public static boolean isValidContext(ApplicationContext context) {
		return context.getBeanNamesForType(CdsRuntimeConfigurer.class).length > 0;
	}

}
