/**************************************************************************
 * (C) 2019-2020 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.framework.spring.feature;

import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;

import com.sap.cds.feature.config.PropertiesProvider;
import com.sap.cds.framework.spring.utils.SpringObjects;

/**
 * A {@code PropertiesProvider} exposing access to all Spring properties.
 *
 * Note that we can't inject Environment via Spring DI as this provider instance is not Spring-managed.
 */
public class SpringPropertiesProvider implements PropertiesProvider {

	@Override
	public <T> T bindPropertyClass(String section, Class<T> clazz) {
		BindResult<T> bindResult = Binder.get(SpringObjects.getEnvironment()).bind(section, Bindable.of(clazz));
		if (bindResult.isBound()) {
			return bindResult.get();
		} else {
			try {
				return clazz.newInstance();
			} catch (InstantiationException | IllegalAccessException e) { // NOSONAR
				return null;
			}
		}
	}

	@Override
	public String getProperty(String key, String defaultValue) {
		return SpringObjects.getEnvironment().getProperty(key, defaultValue);
	}

	@Override
	public <T> T getProperty(String key, Class<T> clazz, T defaultValue) {
		return SpringObjects.getEnvironment().getProperty(key, clazz, defaultValue);
	}

	@Override
	public boolean isActiveFeature() {
		return true;
	}

	@Override
	public String getFeatureName() {
		return "Spring Properties Provider";
	}

}


