/**************************************************************************
 * (C) 2019-2020 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.framework.spring.utils;

import java.lang.reflect.Proxy;
import java.util.function.Supplier;

public class ProxyUtils {

	private ProxyUtils() {
		// empty
	}

	/**
	 * Creates a proxy of the given class and redirects method calls to the object returned by the supplier.
	 * Both {@link Object#hashCode()} and {@link Object#equals(Object)} are not forwarded to the object returned by the supplier.
	 * These two methods are implemented directly, so that every proxy instance has it's own hash code and is distinct from the actual objects returned by the supplier.

	 * @param <T> The type of the proxy
	 * @param clazz The class to proxy
	 * @param supplier The supplier to supply the object to call the method finally on
	 * @return the proxy
	 */
	@SuppressWarnings("unchecked")
	public static <T> T createProxy(Class<T> clazz, Supplier<T> supplier) {
		final Object object = new Object(); // handle hashCode and equals for the proxy via this object
		return (T) Proxy.newProxyInstance(clazz.getClassLoader(), new Class[] { clazz },
				(proxy, method, methodArgs) -> {
					if ("hashCode".equals(method.getName()) || "equals".equals(method.getName())) {
						return method.invoke(object, methodArgs);
					}

					return method.invoke(supplier.get(), methodArgs);
				});
	}

}
