/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.adapter;

import com.sap.cds.adapter.AdapterFactory;
import com.sap.cds.adapter.ServletAdapterFactory;
import com.sap.cds.framework.spring.config.adapter.ServletAdapterRestController;
import com.sap.cds.services.runtime.CdsRuntime;
import javax.servlet.Servlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.SmartFactoryBean;
import org.springframework.beans.factory.annotation.Autowired;

public class AdapterBeanFactory
implements SmartFactoryBean<Object> {
    private static final Logger logger = LoggerFactory.getLogger(AdapterBeanFactory.class);
    private AdapterFactory factory;
    @Autowired
    private CdsRuntime runtime;

    public AdapterBeanFactory(AdapterFactory factory) {
        this.factory = factory;
    }

    public Object getObject() throws Exception {
        Object adapter;
        if (this.factory instanceof ServletAdapterFactory) {
            ServletAdapterFactory servletFactory = (ServletAdapterFactory)this.factory;
            Servlet servlet = servletFactory.createAdapter(this.runtime);
            String servletName = servlet.getClass().getSimpleName();
            String basePath = servletFactory.getBasePath();
            adapter = new ServletAdapterRestController(servlet, basePath);
            logger.info("Servlet {} mapped to {}", (Object)servletName, (Object)basePath);
        } else {
            adapter = this.factory.createAdapter(this.runtime);
            logger.info("Adapter {} initialized", (Object)adapter.getClass().getSimpleName());
        }
        return adapter;
    }

    public Class<?> getObjectType() {
        return Object.class;
    }

    public boolean isEagerInit() {
        return true;
    }
}

