/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.auth;

import com.sap.cds.adapter.ServletUrlResourcePaths;
import com.sap.cds.adapter.UrlResourcePath;
import com.sap.cds.feature.config.Properties;
import com.sap.cds.services.runtime.CdsRuntime;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;

public class ConfigureServletAdapterSecurity {
    private static final Logger logger = LoggerFactory.getLogger(ConfigureServletAdapterSecurity.class);

    public static void configure(CdsRuntime cdsRuntime, HttpSecurity http) throws Exception {
        ServletUrlResourcePaths servletPaths = new ServletUrlResourcePaths(cdsRuntime.getCdsModel());
        if (!Properties.getCds().getSecurity().isAuthenticateUnknownEndpoints()) {
            http.requestMatchers().antMatchers((String[])servletPaths.getBasePaths().map(UrlResourcePath::getPath).toArray(String[]::new));
            logger.info("Configuring authentication of CDS adapter endpoints. Other endpoints are not configured.");
        }
        final ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry urlRegistry = http.authorizeRequests();
        if (Properties.getCds().getSecurity().isOpenUnrestrictedEndpoints()) {
            servletPaths.visit(new ServletUrlResourcePaths.UrlResourcePathVisitor(){

                public void foundPublicPath(UrlResourcePath publicPath) {
                    ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)urlRegistry.antMatchers(new String[]{publicPath.getPath()})).permitAll();
                    logger.debug("Public CDS endpoint {}", (Object)publicPath.getPath());
                }

                public void foundPublicEvents(UrlResourcePath path, Stream<String> publicEvents) {
                    publicEvents.forEach(publicEvent -> {
                        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)urlRegistry.antMatchers(HttpMethod.valueOf((String)publicEvent), new String[]{path.getPath()})).permitAll();
                        logger.debug("Public CDS endpoint {} {}", publicEvent, (Object)path.getPath());
                    });
                    ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)urlRegistry.antMatchers(new String[]{path.getPath()})).authenticated();
                    logger.debug("Authenticate CDS endpoint {}", (Object)path.getPath());
                }
            });
        } else {
            logger.info("Disabled configuration of public CDS adapter endpoints. All CDS adapter endpoints require authentication.");
        }
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)urlRegistry.anyRequest()).authenticated();
    }
}

