/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.runtime;

import com.sap.cds.services.application.ApplicationLifecycleService;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class ApplicationStartedListener
implements ApplicationListener<ApplicationReadyEvent> {
    @Autowired
    private CdsRuntimeConfigurer configurer;

    public void onApplicationEvent(ApplicationReadyEvent applicationReadyEvent) {
        if (!ApplicationStartedListener.isValidContext((ApplicationContext)applicationReadyEvent.getApplicationContext())) {
            return;
        }
        this.configurer.getCdsRuntime().getServiceCatalog().getServices(ApplicationLifecycleService.class).forEach(as -> as.applicationStarted());
    }

    public static boolean isValidContext(ApplicationContext context) {
        return context.getBeanNamesForType(CdsRuntimeConfigurer.class).length > 0;
    }
}

