/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.feature;

import com.sap.cds.feature.config.PropertiesProvider;
import com.sap.cds.framework.spring.utils.SpringObjects;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.core.env.Environment;

public class SpringPropertiesProvider
implements PropertiesProvider {
    public <T> T bindPropertyClass(String section, Class<T> clazz) {
        BindResult bindResult = Binder.get((Environment)SpringObjects.getEnvironment()).bind(section, Bindable.of(clazz));
        if (bindResult.isBound()) {
            return (T)bindResult.get();
        }
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            return null;
        }
    }

    public String getProperty(String key, String defaultValue) {
        return SpringObjects.getEnvironment().getProperty(key, defaultValue);
    }

    public <T> T getProperty(String key, Class<T> clazz, T defaultValue) {
        return (T)SpringObjects.getEnvironment().getProperty(key, clazz, defaultValue);
    }

    public boolean isActiveFeature() {
        return true;
    }

    public String getFeatureName() {
        return "Spring Properties Provider";
    }
}

