/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.utils;

import com.sap.cds.framework.spring.config.runtime.ApplicationStartedListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.slf4j.helpers.MessageFormatter;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class SpringObjects
implements SpringApplicationRunListener {
    private static ApplicationContext context;
    private static volatile Environment environment;
    private static volatile MessageSource messageSource;

    public SpringObjects(SpringApplication application, String[] args) {
    }

    public void environmentPrepared(ConfigurableEnvironment environment) {
        SpringObjects.environment = environment;
    }

    public void started(ConfigurableApplicationContext context) {
        if (!ApplicationStartedListener.isValidContext((ApplicationContext)context)) {
            return;
        }
        SpringObjects.context = context;
        messageSource = (MessageSource)context.getBean(MessageSource.class);
    }

    public static Environment getEnvironment() {
        if (environment == null) {
            throw new IllegalStateException("Accessed environment before it was available");
        }
        return environment;
    }

    public static MessageSource getMessageSource() {
        return messageSource;
    }

    public static <T> List<T> getBeans(Class<T> clazz) {
        String[] beanNames;
        if (context == null) {
            throw new IllegalStateException("Accessed context before it was available");
        }
        ArrayList<Object> beans = new ArrayList<Object>();
        for (String beanName : beanNames = context.getBeanNamesForType(clazz)) {
            beans.add(context.getBean(beanName));
        }
        return beans;
    }

    static {
        messageSource = new MessageSource(){

            public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
                if (code != null) {
                    return MessageFormatter.arrayFormat((String)code, (Object[])args).getMessage();
                }
                return defaultMessage;
            }

            public String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
                return MessageFormatter.arrayFormat((String)code, (Object[])args).getMessage();
            }

            public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
                return resolvable.getDefaultMessage();
            }
        };
    }
}

