/**************************************************************************
 * (C) 2019-2020 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.framework.spring.config.adapter;

import javax.servlet.Servlet;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.SmartFactoryBean;
import org.springframework.beans.factory.annotation.Autowired;

import com.sap.cds.adapter.AdapterFactory;
import com.sap.cds.adapter.ServletAdapterFactory;
import com.sap.cds.services.runtime.CdsRuntime;

/**
 * Factory bean to create an adapter as bean based on a {@link AdapterFactory}
 */
public class AdapterBeanFactory implements SmartFactoryBean<Object> {

	private final static Logger logger = LoggerFactory.getLogger(AdapterBeanFactory.class);

	private AdapterFactory factory;

	@Autowired
	private CdsRuntime runtime;

	public AdapterBeanFactory(AdapterFactory factory) {
		this.factory = factory;
	}

	@Override
	public Object getObject() throws Exception {
		Object adapter;

		if(factory instanceof ServletAdapterFactory) {
			ServletAdapterFactory servletFactory = (ServletAdapterFactory) factory;
			Servlet servlet = servletFactory.createAdapter(runtime);

			String servletName = servlet.getClass().getSimpleName();
			String basePath = servletFactory.getBasePath();

			adapter = new ServletAdapterRestController(servlet, basePath);
			logger.info("Servlet {} mapped to {}", servletName, basePath);
		} else {
			adapter = factory.createAdapter(runtime);
			logger.info("Adapter {} initialized", adapter.getClass().getSimpleName());
		}

		return adapter;
	}

	@Override
	public Class<?> getObjectType() {
		return Object.class;
	}

	@Override
	public boolean isEagerInit() {
		return true;
	}

}
