/**************************************************************************
 * (C) 2019-2020 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.framework.spring.config.adapter;

import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

import com.sap.cds.adapter.odata.v2.CdsODataV2ServiceFactory;
import com.sap.cds.adapter.odata.v4.CdsODataV4Servlet;

@Configuration
@Conditional(ODataConfiguredCondition.class)
public class ODataPropertyConfig {

	@Configuration
	@ConditionalOnClass(CdsODataV4Servlet.class)
	@PropertySource("classpath:/odata.properties")
	public static class ODataV4 {

	}

	@Configuration
	@ConditionalOnClass(CdsODataV2ServiceFactory.class)
	@PropertySource("classpath:/odata.properties")
	public static class ODataV2 {

	}

}
