/**************************************************************************
 * (C) 2019-2020 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.framework.spring.config.auth;

import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

import com.sap.cds.feature.config.Properties;

/**
 * A {@link Condition} that helps to decide if mock users are configured or not.
 */
public class MockUsersConfiguredCondition implements Condition {

	@Override
	public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
		// Note: mock users configuration also applies if there are no mock users defined actually.
		// Unrestricted CDS endpoints will be available for anonymous user.
		return Properties.getCds().getSecurity().getMock().isEnabled();
	}
}
