/**************************************************************************
 * (C) 2019-2020 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.framework.spring.config.auth;

import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

import com.sap.cloud.security.xsuaa.XsuaaServiceConfiguration;
import com.sap.cloud.security.xsuaa.XsuaaServiceConfigurationDefault;

@Configuration
@ConditionalOnClass({ XsuaaServiceConfiguration.class }) // only if xsuaa library has been loaded
@PropertySource("classpath:/xsuaa.properties") // disable xsuaa property source
@PropertySource(factory = XsuaaPropertiesFactory.class, value = "") // dynamically load xsuaa properties based on service binding
public class XsuaaConfigurationConfig {

	@Bean
	@ConditionalOnMissingBean
	@Conditional(XsuaaConfiguredCondition.class)
	public XsuaaServiceConfiguration xsuaaServiceConfiguration() {
		return new XsuaaServiceConfigurationDefault();
	}

}
