/**************************************************************************
 * (C) 2019-2020 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.framework.spring.config.auth;

import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

import com.sap.cds.feature.config.Properties;
import com.sap.cds.services.utils.XsuaaUtils;

/**
 * A {@link Condition} that helps to decide if XSUAA is configured or not.
 * Note that the xsuaa properties could be injected via custom XsuaaServicePropertySourceFactory.
 */
public class XsuaaConfiguredCondition implements Condition {

	@Override
	public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
		return Properties.getCds().getSecurity().getXsuaa().isEnabled() &&
				Properties.getCds().getSecurity().getXsuaa().getAuthConfig().isEnabled() &&
				!XsuaaUtils.getXsuaaServiceBindings().isEmpty();
	}

}
