/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.actuator;

import com.sap.cds.feature.config.Properties;
import com.sap.cloud.mt.runtime.DbHealthIndicatorImpl;
import com.sap.cloud.mt.runtime.TenantAwareDataSource;
import javax.sql.DataSource;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.jdbc.DataSourceHealthIndicator;

public class DbHealthIndicatorMt
implements HealthIndicator {
    private DbHealthIndicatorImpl<Health> dbHealthIndicatorMt;
    private DataSourceHealthIndicator dbHealthIndicatorSt;

    public DbHealthIndicatorMt(DataSource dataSource) {
        boolean newCheck;
        long intervallMillis = Properties.getCds().getMultiTenancy().getHealthCheck().getIntervalMillis();
        String healthCheckStatement = Properties.getCds().getMultiTenancy().getHealthCheck().getHealthCheckStatement();
        boolean bl = newCheck = !Properties.getCds().getMultiTenancy().getDataSource().getHanaDatabaseIds().isEmpty();
        if (dataSource instanceof TenantAwareDataSource) {
            this.dbHealthIndicatorMt = new DbHealthIndicatorImpl(healthCheckStatement, (TenantAwareDataSource)dataSource, Long.valueOf(intervallMillis), () -> Health.up().build(), () -> Health.down().build(), (text, details) -> Health.down().withDetail(text, (Object)details).build(), (text, details) -> Health.up().withDetail(text, (Object)details).build(), newCheck);
        } else {
            this.dbHealthIndicatorSt = new DataSourceHealthIndicator(dataSource);
        }
    }

    public Health health() {
        if (this.dbHealthIndicatorMt != null) {
            return (Health)this.dbHealthIndicatorMt.health();
        }
        return this.dbHealthIndicatorSt.health();
    }
}

