/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.auth;

import com.sap.cds.feature.config.Properties;
import com.sap.cds.feature.config.pojo.CdsProperties;
import com.sap.cds.framework.spring.config.auth.ConfigureServletAdapterSecurity;
import com.sap.cds.framework.spring.config.auth.MockUsersConfiguredCondition;
import com.sap.cds.framework.spring.config.auth.XsuaaSecurityConfig;
import com.sap.cds.services.runtime.CdsRuntime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configurers.provisioning.InMemoryUserDetailsManagerConfigurer;
import org.springframework.security.config.annotation.web.WebSecurityConfigurer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.PasswordEncoder;

@Configuration
@ConditionalOnClass(value={WebSecurityConfigurer.class})
@AutoConfigureAfter(value={XsuaaSecurityConfig.class})
@ConditionalOnMissingBean(value={XsuaaSecurityConfig.class})
@Conditional(value={MockUsersConfiguredCondition.class})
@EnableWebSecurity
@Order(value=1000)
public class MockUsersSecurityConfig
extends WebSecurityConfigurerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(MockUsersSecurityConfig.class);
    @Autowired
    private CdsRuntime cdsRuntime;

    public void configure(AuthenticationManagerBuilder auth) throws Exception {
        List users = Properties.getCds().getSecurity().getMock().getUsers();
        if (users.isEmpty()) {
            logger.warn("No mock users found in configuration. Spring standard authentication manager with default user 'user' (password written to console) is available");
            super.configure(auth);
            return;
        }
        InMemoryUserDetailsManagerConfigurer authConfigurer = auth.inMemoryAuthentication();
        PasswordEncoder encoder = PasswordEncoderFactories.createDelegatingPasswordEncoder();
        authConfigurer.passwordEncoder(encoder);
        for (CdsProperties.Security.Mock.User user : users) {
            if (!user.isValid()) {
                logger.warn("Skipping invalid mock user defintion {} ('name' and 'password' required)", (Object)user);
                continue;
            }
            authConfigurer.withUser(user.getName()).password(encoder.encode((CharSequence)user.getPassword())).authorities(user.getRoles().toArray(new String[0]));
            logger.info("Added mock user {}", (Object)user);
        }
    }

    public void configure(HttpSecurity http) throws Exception {
        http.csrf().disable();
        ConfigureServletAdapterSecurity.configure(this.cdsRuntime, http);
        http.httpBasic();
        logger.info("*************************************************************************");
        logger.info("*  Security configuration based on mock users found in active profile.  *");
        logger.info("*                 !!! NEVER USE IN PRODUCTIVE MODE !!!                  *");
        logger.info("*************************************************************************");
    }
}

