/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.auth;

import com.sap.cds.feature.config.Properties;
import com.sap.cds.feature.platform.ServiceBinding;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.services.utils.XsuaaUtils;
import com.sap.cloud.security.xsuaa.XsuaaServicePropertySourceFactory;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.core.io.support.PropertySourceFactory;

public class XsuaaPropertiesFactory
implements PropertySourceFactory {
    private static final Logger logger = LoggerFactory.getLogger(XsuaaPropertiesFactory.class);
    private static final String propertySourceName = "cds-xsuaa";

    public PropertySource<?> createPropertySource(String name, EncodedResource resource) throws IOException {
        List bindings = XsuaaUtils.getXsuaaServiceBindings();
        if (bindings.isEmpty()) {
            String xsuaaServiceName = Properties.getCds().getSecurity().getXsuaa().getServiceName();
            if (StringUtils.isEmpty((String)xsuaaServiceName)) {
                logger.info("No service binding with tag 'xsuaa' found");
            } else {
                logger.info("No service binding with tag 'xsuaa' and name '{}' found", (Object)xsuaaServiceName);
            }
            return new PropertiesPropertySource(propertySourceName, new java.util.Properties());
        }
        if (bindings.size() > 1) {
            logger.warn("Multiple service bindings with tag 'xsuaa' found");
        }
        ServiceBinding binding = (ServiceBinding)bindings.get(0);
        logger.info("Using service binding '{}' to configure 'xsuaa' properties section", (Object)binding.getServiceInstanceName());
        java.util.Properties props = new java.util.Properties();
        props.putAll((Map<?, ?>)binding.getCredentials());
        return XsuaaServicePropertySourceFactory.create((String)propertySourceName, (java.util.Properties)props);
    }
}

