/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.auth;

import com.sap.cds.framework.spring.config.auth.ConfigureServletAdapterSecurity;
import com.sap.cds.framework.spring.config.auth.XsuaaConfiguredCondition;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cloud.security.xsuaa.XsuaaServiceConfiguration;
import com.sap.cloud.security.xsuaa.token.TokenAuthenticationConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.config.annotation.web.WebSecurityConfigurer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.oauth2.jwt.Jwt;

@Configuration
@ConditionalOnClass(value={XsuaaServiceConfiguration.class, WebSecurityConfigurer.class, Jwt.class})
@Conditional(value={XsuaaConfiguredCondition.class})
@EnableWebSecurity
@Order(value=1000)
public class XsuaaSecurityConfig
extends WebSecurityConfigurerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(XsuaaSecurityConfig.class);
    @Autowired
    private XsuaaServiceConfiguration xsuaaServiceConfiguration;
    @Autowired
    private CdsRuntime cdsRuntime;

    protected void configure(HttpSecurity http) throws Exception {
        http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
        ConfigureServletAdapterSecurity.configure(this.cdsRuntime, http);
        http.oauth2ResourceServer().jwt().jwtAuthenticationConverter(this.getJwtAuthoritiesConverter());
        logger.info("Activated XSUAA security configuration based on OAuth 2");
    }

    Converter<Jwt, AbstractAuthenticationToken> getJwtAuthoritiesConverter() {
        TokenAuthenticationConverter converter = new TokenAuthenticationConverter(this.xsuaaServiceConfiguration);
        converter.setLocalScopeAsAuthorities(true);
        return converter;
    }
}

