/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.runtime;

import com.sap.cds.CdsDataStore;
import com.sap.cds.framework.spring.transaction.PlatformTransactionManagerPostProcessor;
import com.sap.cds.framework.spring.transaction.SpringTransactionManager;
import com.sap.cds.framework.spring.utils.ProxyUtils;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.impl.persistence.JdbcPersistenceService;
import com.sap.cds.services.impl.persistence.JdbcPersistenceServiceConfiguration;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.transaction.TransactionManager;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceTransactionManagerAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@ConditionalOnClass(value={JdbcPersistenceServiceConfiguration.class, TransactionAwareDataSourceProxy.class, PlatformTransactionManager.class})
@ConditionalOnBean(value={DataSource.class, PlatformTransactionManager.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class, DataSourceTransactionManagerAutoConfiguration.class})
public class SpringJdbcPersistenceServiceConfiguration {
    private final JdbcPersistenceServiceConfiguration configuration;

    @Autowired
    public SpringJdbcPersistenceServiceConfiguration(DataSource dataSource, PlatformTransactionManager platformTransactionManager) {
        SpringTransactionManager txMgr = ((PlatformTransactionManagerPostProcessor.SpringTransactionManagerGetter)platformTransactionManager).getSpringTransactionManager();
        TransactionAwareDataSourceProxy txAwareDataSource = new TransactionAwareDataSourceProxy(dataSource);
        Supplier<Connection> connectionSupplier = () -> SpringJdbcPersistenceServiceConfiguration.lambda$new$0((DataSource)txAwareDataSource);
        this.configuration = JdbcPersistenceServiceConfiguration.create(connectionSupplier, (TransactionManager)txMgr);
    }

    @Bean(value={"PersistenceService$Default"})
    public JdbcPersistenceService persistenceService(CdsRuntime runtime) {
        return this.configuration.getService(runtime);
    }

    @Bean
    public CdsDataStore cdsDataStore(CdsRuntime runtime) {
        JdbcPersistenceService persistenceService = this.configuration.getService(runtime);
        return ProxyUtils.createProxy(CdsDataStore.class, () -> persistenceService.getCdsDataStore());
    }

    private static /* synthetic */ Connection lambda$new$0(DataSource txAwareDataSource) {
        try {
            return txAwareDataSource.getConnection();
        }
        catch (SQLException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.JDBC_CONNECTION_FAILED, new Object[]{e});
        }
    }
}

