/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.feature;

import com.sap.cds.feature.auth.AuthenticatedUserClaimProvider;
import com.sap.cds.feature.config.Properties;
import com.sap.cds.framework.spring.utils.SpringObjects;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;

public class SpringAuthenticatedUserClaimProvider
implements AuthenticatedUserClaimProvider {
    private static boolean securityContextAvailable;
    private static boolean oauth2ClientAvailable;
    private static boolean oauth2ResourceAvailable;
    private static boolean basicAuthAvailable;

    public String getUserClaim() {
        String token = null;
        if (securityContextAvailable) {
            Object principal;
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            if (basicAuthAvailable && token == null && auth instanceof UsernamePasswordAuthenticationToken && (principal = ((UsernamePasswordAuthenticationToken)auth).getPrincipal()) instanceof User) {
                token = ((User)principal).getUsername();
            }
            if (oauth2ClientAvailable && token == null && auth instanceof OAuth2AuthenticationToken) {
                String authorizedClientRegistrationId = ((OAuth2AuthenticationToken)auth).getAuthorizedClientRegistrationId();
                String principalName = ((OAuth2AuthenticationToken)auth).getName();
                for (OAuth2AuthorizedClientService clientService : SpringObjects.getBeans(OAuth2AuthorizedClientService.class)) {
                    OAuth2AuthorizedClient authorizedClient = clientService.loadAuthorizedClient(authorizedClientRegistrationId, principalName);
                    if (authorizedClient == null) continue;
                    token = authorizedClient.getAccessToken().getTokenValue();
                    break;
                }
            }
            if (oauth2ResourceAvailable && token == null && auth instanceof JwtAuthenticationToken) {
                token = ((Jwt)((JwtAuthenticationToken)auth).getToken()).getTokenValue();
            }
        }
        return token;
    }

    public boolean isActiveFeature() {
        try {
            boolean mockUsersAvailable = !Properties.getCds().getSecurity().getMock().getUsers().isEmpty();
            return securityContextAvailable && (oauth2ClientAvailable || oauth2ResourceAvailable || basicAuthAvailable && mockUsersAvailable);
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getFeatureName() {
        return "Spring Authentication Claim Provider";
    }

    static {
        try {
            securityContextAvailable = SecurityContextHolder.class.getName() != null;
        }
        catch (NoClassDefFoundError e) {
            securityContextAvailable = false;
        }
        try {
            oauth2ClientAvailable = OAuth2AuthenticationToken.class.getName() != null;
        }
        catch (NoClassDefFoundError e) {
            oauth2ClientAvailable = false;
        }
        try {
            oauth2ResourceAvailable = JwtAuthenticationToken.class.getName() != null;
        }
        catch (NoClassDefFoundError e) {
            oauth2ResourceAvailable = false;
        }
        try {
            basicAuthAvailable = UsernamePasswordAuthenticationToken.class.getName() != null;
        }
        catch (NoClassDefFoundError e) {
            basicAuthAvailable = false;
        }
    }
}

