/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.feature;

import com.sap.cds.feature.localization.DefaultLocalizedMessageProvider;
import com.sap.cds.feature.localization.LocalizedMessageProvider;
import com.sap.cds.framework.spring.utils.SpringObjects;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class SpringLocalizedMessageProvider
implements LocalizedMessageProvider {
    private static final Logger logger = LoggerFactory.getLogger(SpringLocalizedMessageProvider.class);

    public String getMessage(String code, Object[] args, Locale locale) {
        try {
            String message = SpringObjects.getMessageSource().getMessage(code, args, null, DefaultLocalizedMessageProvider.getLocaleForBundle((Locale)locale));
            if (message != null) {
                return message;
            }
            return MessageFormatter.arrayFormat((String)code, (Object[])args).getMessage();
        }
        catch (Exception e) {
            logger.warn("Invalid message format '{}' or incompatible arguments {}", new Object[]{code, SpringLocalizedMessageProvider.toStringSafely(args), e});
            return code;
        }
    }

    private static String toStringSafely(Object[] args) {
        if (args != null) {
            StringBuffer sb = new StringBuffer();
            for (Object arg : args) {
                sb.append('<');
                try {
                    sb.append(arg.toString());
                }
                catch (Exception e) {
                    sb.append(e.getMessage());
                }
                sb.append('>');
            }
            return sb.toString();
        }
        return "<null>";
    }

    public boolean isActiveFeature() {
        return true;
    }

    public String getFeatureName() {
        return "Spring Localized Message Provider";
    }
}

