/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cds.feature.config.Properties;
import com.sap.cds.feature.config.pojo.CdsProperties;
import com.sap.cds.mtx.impl.ClientCredentialJwtAccess;
import com.sap.cds.services.mt.MtSubscriptionService;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.mtx.MtxUtils;
import com.sap.cloud.mt.subscription.json.SidecarUpgradePayload;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;

@SpringBootApplication
public class Deploy {
    private static final Logger log = LoggerFactory.getLogger(Deploy.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final String SIDECAR_STATUS_RUNNING = "RUNNING";
    private static final String SIDECAR_RESPONSE_FIELD_STATUS = "status";
    private static final String SIDECAR_RESPONSE_FIELD_ERROR = "error";
    private static final String SIDECAR_RESPONSE_FIELD_JOB_ID = "jobID";
    private static final String PARAMETER_ALL_TENANTS = "all";

    public static void main(String[] args) throws Exception {
        try {
            System.setProperty("cds.security.xsuaa.enabled", "false");
            System.setProperty("cds.security.mock.enabled", "false");
            System.setProperty("cds.messaging.receiver.enabled", "false");
            CdsRuntime runtime = (CdsRuntime)new SpringApplicationBuilder(new Class[]{Deploy.class}).web(WebApplicationType.NONE).run(new String[0]).getBean(CdsRuntime.class);
            MtSubscriptionService mtService = (MtSubscriptionService)runtime.getServiceCatalog().getService(MtSubscriptionService.class, "MtSubscriptionService$Default");
            assert (!Properties.getCds().getSecurity().getXsuaa().isEnabled().booleanValue());
            assert (!Properties.getCds().getSecurity().getMock().isEnabled().booleanValue());
            assert (!Properties.getCds().getMessaging().getReceiver().isEnabled().booleanValue());
            if (mtService != null) {
                long timestamp = System.currentTimeMillis();
                CharSequence[] tenants = Arrays.copyOf(args, args.length);
                if (tenants.length == 0) {
                    tenants = new String[]{PARAMETER_ALL_TENANTS};
                    log.info("Starting database update for all tenants");
                } else {
                    log.info("Starting database update for tenant(s) {}", (Object)String.join((CharSequence)", ", tenants));
                }
                SidecarUpgradePayload upgradePayload = new SidecarUpgradePayload();
                upgradePayload.tenants = tenants;
                CdsProperties.MultiTenancy config = Properties.getCds().getMultiTenancy();
                String deployScope = config.getSecurity().getDeploymentScope();
                runtime.requestContext().clearUser().modifyUser(user -> user.addRole(deployScope).setIsAuthenticated(true)).run(context -> {
                    if (MtxUtils.mtxEnabled()) {
                        try {
                            ClientCredentialJwtAccess jwtAccess = new ClientCredentialJwtAccess(MtxUtils.createClientCredentialJwtReader());
                            String jobId = Deploy.startDbDeploymentSidecar(upgradePayload, mtService, jwtAccess);
                            Deploy.waitForDeploymentToFinish(jobId, mtService, jwtAccess);
                        }
                        catch (Throwable t) {
                            throw new RuntimeException(t);
                        }
                    } else {
                        mtService.deploy(upgradePayload);
                    }
                    return null;
                });
                log.info("Database update finished successfully in {}s", (Object)((System.currentTimeMillis() - timestamp) / 1000L));
            } else {
                log.error("Failed: MT Service not found");
                Deploy.logErrorMessage();
                System.exit(2);
            }
        }
        catch (Throwable t) {
            log.error("Unexpected error", t);
            Deploy.logErrorMessage();
            System.exit(1);
        }
        Deploy.logSuccessMessage();
        System.exit(0);
    }

    private static String startDbDeploymentSidecar(SidecarUpgradePayload upgradePayload, MtSubscriptionService mtService, ClientCredentialJwtAccess jwtAccess) throws Exception {
        String jobIdResultStr = mtService.asyncDeploy(upgradePayload, MtxUtils.getBearerAuthorizationHeader((String)jwtAccess.getJwt()));
        TypeReference<Map<String, String>> typeRefStr = new TypeReference<Map<String, String>>(){};
        Map jobIdResult = (Map)mapper.readValue(jobIdResultStr, (TypeReference)typeRefStr);
        return (String)jobIdResult.get(SIDECAR_RESPONSE_FIELD_JOB_ID);
    }

    private static void waitForDeploymentToFinish(String jobId, MtSubscriptionService mtService, ClientCredentialJwtAccess jwtAccess) throws Exception {
        String resultStr;
        Map result;
        String status;
        TypeReference<Map<String, Object>> typeRef = new TypeReference<Map<String, Object>>(){};
        long lastTimestamp = 0L;
        do {
            if (System.currentTimeMillis() - lastTimestamp > 60000L) {
                log.info("Waiting for database update to finish...");
                lastTimestamp = System.currentTimeMillis();
            }
            Thread.sleep(2000L);
        } while (SIDECAR_STATUS_RUNNING.equals(status = (String)(result = (Map)mapper.readValue(resultStr = mtService.asyncDeployStatus(jobId, MtxUtils.getBearerAuthorizationHeader((String)jwtAccess.getJwt())), (TypeReference)typeRef)).get(SIDECAR_RESPONSE_FIELD_STATUS)));
        if (result.get(SIDECAR_RESPONSE_FIELD_ERROR) != null) {
            log.error("Database update failed, last sidecar response: {}", (Object)resultStr);
            Deploy.logErrorMessage();
            System.exit(3);
        }
        log.debug("Last sidecar response: {}", (Object)resultStr);
    }

    private static void logSuccessMessage() {
        log.info("*************");
        log.info("*  SUCCESS  *");
        log.info("*************");
    }

    private static void logErrorMessage() {
        log.error("***********");
        log.error("*  ERROR  *");
        log.error("***********");
    }
}

