package com.sap.cds.framework.spring.config.auth;

import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import com.sap.cds.feature.xsuaa.XsuaaUserInfoProvider;
import com.sap.cds.services.utils.XsuaaUtils;

@Configuration
@ConditionalOnClass(XsuaaUserInfoProvider.class) // optionally loaded with cds-feature-xsuaa
@AutoConfigureBefore(DefaultXsuaaFeatureConfig.class)
public class LoadedXsuaaFeatureConfig {

	@Bean
	public XsuaaFeature xsuaaFeature() {
		return () -> XsuaaUtils.xsuaaConfiguredCondition();
	}

}
