/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.framework.spring.config.auth;

import java.io.IOException;
import java.util.List;
import java.util.Properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.core.io.support.PropertySourceFactory;

import com.sap.cds.feature.platform.ServiceBinding;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.services.utils.XsuaaUtils;
import com.sap.cloud.security.xsuaa.XsuaaServicePropertySourceFactory;

public class XsuaaPropertiesFactory implements PropertySourceFactory {

	private final static Logger logger = LoggerFactory.getLogger(XsuaaPropertiesFactory.class);

	private final static String propertySourceName = "cds-xsuaa";

	@Override
	public PropertySource<?> createPropertySource(String name, EncodedResource resource) throws IOException {
		List<ServiceBinding> bindings = XsuaaUtils.getXsuaaServiceBindings();
		if(bindings.isEmpty()) {
			String xsuaaServiceBinding = com.sap.cds.feature.config.Properties.getCds().getSecurity().getXsuaa().getBinding();
			if (StringUtils.isEmpty(xsuaaServiceBinding)) {
				logger.info("No service binding with tag 'xsuaa' found");
			} else {
				logger.info("No service binding with tag 'xsuaa' and name '{}' found", xsuaaServiceBinding);
			}
			return new PropertiesPropertySource(propertySourceName, new Properties());
		} else if (bindings.size() > 1) {
			logger.warn("Multiple service bindings with tag 'xsuaa' found");
		}

		ServiceBinding binding = bindings.get(0);
		logger.info("Using service binding '{}' to configure 'xsuaa' properties section", binding.getName());
		Properties props = new Properties();
		props.putAll(binding.getCredentials());
		return XsuaaServicePropertySourceFactory.create(propertySourceName, props);
	}

}
