/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.framework.spring.config.runtime;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

import com.sap.cds.framework.spring.utils.ProxyUtils;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.ServiceCatalog;
import com.sap.cds.services.messages.Messages;
import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.CdsRuntime;

@Configuration
public class RequestContextConfig {

	@Bean
	public CdsModel cdsModel(CdsRuntime runtime) {
		return ProxyUtils.createProxy(CdsModel.class, () -> RequestContext.getCurrent(runtime).getModel());
	}

	@Bean
	public ServiceCatalog serviceCatalog(CdsRuntime runtime) {
		return ProxyUtils.createProxy(ServiceCatalog.class, () -> RequestContext.getCurrent(runtime).getServiceCatalog());
	}

	@Bean
	@Primary
	public UserInfo userInfo(CdsRuntime runtime) {
		return ProxyUtils.createProxy(UserInfo.class, () -> RequestContext.getCurrent(runtime).getUserInfo());
	}

	@Bean
	public Messages messages(CdsRuntime runtime) {
		return ProxyUtils.createProxy(Messages.class, () -> RequestContext.getCurrent(runtime).getMessages());
	}

	@Bean
	public ParameterInfo parameterInfo(CdsRuntime runtime) {
		return ProxyUtils.createProxy(ParameterInfo.class, () -> RequestContext.getCurrent(runtime).getParameterInfo());
	}

}
