/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.framework.spring.config.runtime;

import org.springframework.beans.factory.FactoryBean;

import com.sap.cds.services.runtime.CdsRuntime;

/**
 * Factory bean to create a {@link CdsRuntime}
 */
public class SimpleBeanFactory<T> implements FactoryBean<T> {

	private final T bean;

	public SimpleBeanFactory(T bean) {
		this.bean = bean;
	}

	@Override
	public T getObject() throws Exception {
		return bean;
	}

	@Override
	public Class<?> getObjectType() {
		return bean.getClass();
	}

}
