/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.framework.spring.servicedescriptor;

import java.util.Optional;

import javax.sql.DataSource;

import org.springframework.beans.factory.FactoryBean;

import com.sap.cds.feature.services.db.DataSourceDescriptor;
import com.sap.cds.feature.services.db.DataSourceProvider;
import com.sap.cds.feature.services.util.DataSourceProviderUtils;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;

/**
 * Auto-configures a DataSource in Spring, based on a given {@link DataSourceDescriptor}
 */
public class DataSourceConnector implements FactoryBean<DataSource> {

	private final DataSourceDescriptor descriptor;
	private final CdsRuntime runtime;
	private DataSource dataSource;

	public DataSourceConnector(DataSourceDescriptor descriptor, CdsRuntime runtime) {
		this.descriptor = descriptor;
		this.runtime = runtime;
	}

	@Override
	public DataSource getObject() throws Exception {
		if(dataSource == null) {
			Optional<DataSourceProvider> provider = DataSourceProviderUtils.getDataSourceProvider(descriptor, runtime);
			dataSource = provider.orElseThrow(() -> new ErrorStatusException(CdsErrorStatuses.NO_DATA_SOURCE_PROVIDER, descriptor.getName())).create(descriptor);
		}
		return dataSource;
	}

	@Override
	public Class<?> getObjectType() {
		return descriptor.getConnectedType();
	}

}
