/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.actuator;

import com.google.common.collect.Lists;
import com.sap.cds.adapter.ServletUrlResourcePaths;
import com.sap.cds.adapter.UrlResourcePath;
import com.sap.cds.feature.config.Properties;
import com.sap.cds.feature.config.pojo.CdsProperties;
import com.sap.cds.framework.spring.config.auth.MockUsersSecurityConfig;
import com.sap.cds.framework.spring.config.auth.XsuaaSecurityConfig;
import com.sap.cds.framework.spring.mt.MtFeature;
import com.sap.cds.framework.spring.utils.SpringObjects;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.info.CdsInfo;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.WebSecurityConfigurer;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;

@Configuration
@ConditionalOnClass(value={WebSecurityConfigurer.class})
public class CdsSecurityInfo {
    private Authentication authentication;
    private CdsRuntime cdsRuntime;
    private MtFeature mtFeature;

    @Autowired
    public CdsSecurityInfo(List<WebSecurityConfigurerAdapter> adapters, CdsRuntime cdsRuntime, MtFeature mtFeature) {
        this.cdsRuntime = cdsRuntime;
        this.mtFeature = mtFeature;
        this.authentication = Authentication.NONE;
        if (adapters != null) {
            this.authentication = Stream.of(Authentication.values()).filter(e -> ((Authentication)e).config != null && adapters.stream().filter(a -> ((Authentication)e).config.isAssignableFrom(a.getClass())).findAny().isPresent()).findFirst().orElse(Authentication.CUSTOM);
        }
    }

    private Map<String, Object> authentication() {
        return new LinkedHashMap<String, Object>(){
            {
                this.put("name", CdsSecurityInfo.this.authentication.name);
                if (CdsSecurityInfo.this.authentication.type != null) {
                    this.put("type", CdsSecurityInfo.this.authentication.type);
                }
                if (CdsSecurityInfo.this.authentication.remark != null) {
                    this.put("remark", CdsSecurityInfo.this.authentication.remark);
                }
            }
        };
    }

    private Map<String, Object> authorization() {
        return new LinkedHashMap<String, Object>(){
            {
                CdsProperties.Security security = Properties.getCds().getSecurity();
                this.put("authenticate-unknown-endpoints", security.isAuthenticateUnknownEndpoints());
                this.put("instance-based-authorization", security.getInstanceBasedAuthorization().isEnabled());
                this.put("open-unrestricted-endpoints", security.getOpenUnrestrictedEndpoints(CdsSecurityInfo.this.mtFeature.isActive()));
                this.put("draft-protection", security.getDraftProtection().isEnabled());
            }
        };
    }

    private Map<String, List<String>> publicEndpoints() {
        final LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
        if ((this.authentication == Authentication.MOCK || this.authentication == Authentication.XSUAA) && Properties.getCds().getSecurity().getOpenUnrestrictedEndpoints(this.mtFeature.isActive())) {
            new ServletUrlResourcePaths(this.cdsRuntime).visit(new ServletUrlResourcePaths.UrlResourcePathVisitor(){

                public void foundPublicPath(UrlResourcePath publicPath) {
                    result.put(publicPath.getPath(), Lists.newArrayList((Object[])new String[]{"*"}));
                }

                public void foundPublicEvents(UrlResourcePath path, Stream<String> publicEvents) {
                    List publicEventList = publicEvents.collect(Collectors.toList());
                    if (!publicEventList.isEmpty()) {
                        result.put(path.getPath(), publicEventList);
                    }
                }
            });
        }
        return result;
    }

    public static class CdsSecurityInfoImpl
    implements CdsInfo {
        public Map<String, Object> info(final CdsInfo.Details details) {
            final CdsSecurityInfo securityInfo = SpringObjects.getBeans(CdsSecurityInfo.class).stream().findFirst().orElse(null);
            return new LinkedHashMap<String, Object>(){
                {
                    if (securityInfo != null) {
                        Map publicEndpoints;
                        this.put("authentication", securityInfo.authentication());
                        this.put("authorization", securityInfo.authorization());
                        if (details == CdsInfo.Details.HIGH && !(publicEndpoints = securityInfo.publicEndpoints()).isEmpty()) {
                            this.put("public CDS adapter endpoints", publicEndpoints);
                        }
                    } else {
                        this.put("authentication", new LinkedHashMap<String, Object>(){
                            {
                                this.put("name", "Not configured");
                                this.put("remark", "All endpoints are public!");
                            }
                        });
                    }
                }
            };
        }

        public String name() {
            return "security";
        }
    }

    static enum Authentication {
        NONE("Not configured", null, "All endpoints are public!", null),
        CUSTOM("Custom", "<unknown>", "Make sure CDS adapter endpoints are secured accordingly", null),
        MOCK("Mock users", "Basic", "Not appropriate for productive usage!", MockUsersSecurityConfig.class),
        XSUAA("XSUAA", "OAuth2", null, XsuaaSecurityConfig.class);

        private final String name;
        private final String type;
        private final String remark;
        private final Class<?> config;

        private Authentication(String name, String type, String remark, Class<?> config) {
            this.name = name;
            this.type = type;
            this.remark = remark;
            this.config = config;
        }
    }
}

