/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.adapter;

import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

@RestController
@ConditionalOnBean(value={Servlet.class})
public class ServletAdapterRestController
implements Controller {
    private final Servlet servlet;
    private final int beginIndex;

    public ServletAdapterRestController(Servlet servlet, String basePath) {
        this.servlet = servlet;
        this.beginIndex = basePath.length();
    }

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.servlet.service((ServletRequest)new HttpServletRequestForRestController(request, this.beginIndex), (ServletResponse)response);
        return null;
    }

    private static class HttpServletRequestForRestController
    extends HttpServletRequestWrapper {
        private final int beginIndex;

        public HttpServletRequestForRestController(HttpServletRequest request, int beginIndex) {
            super(request);
            this.beginIndex = beginIndex;
        }

        public String getPathInfo() {
            String pathInfo = super.getPathInfo();
            if (pathInfo == null) {
                pathInfo = super.getServletPath();
            }
            return pathInfo.substring(this.beginIndex);
        }
    }
}

