/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.transaction;

import com.sap.cds.services.transaction.TransactionManager;
import java.util.Stack;
import java.util.UUID;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SpringTransactionManager
implements TransactionManager {
    private final PlatformTransactionManager txMgr;
    private final ThreadLocal<Stack<TransactionStatus>> transactions = ThreadLocal.withInitial(() -> new Stack());
    private final String name = "spring-" + UUID.randomUUID().toString();

    public SpringTransactionManager(PlatformTransactionManager txMgr) {
        this.txMgr = txMgr;
    }

    public boolean isActive() {
        return TransactionSynchronizationManager.isActualTransactionActive();
    }

    public void begin() {
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition(3);
        TransactionStatus tx = null;
        try {
            tx = this.txMgr.getTransaction((TransactionDefinition)definition);
        }
        finally {
            this.transactions.get().push(tx);
        }
    }

    public void commit() {
        TransactionStatus tx = this.transactions.get().pop();
        if (tx != null) {
            this.txMgr.commit(tx);
        }
    }

    public void rollback() {
        TransactionStatus tx = this.transactions.get().pop();
        if (tx != null) {
            this.txMgr.rollback(tx);
        }
    }

    public boolean isRollbackOnly() {
        TransactionStatus tx = this.transactions.get().peek();
        if (tx != null) {
            return tx.isRollbackOnly();
        }
        return true;
    }

    public void setRollbackOnly() {
        TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
    }

    public String getName() {
        return this.name;
    }
}

