/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.runtime;

import com.sap.cds.services.Service;
import com.sap.cds.services.ServiceCatalog;
import com.sap.cds.services.application.ApplicationLifecycleService;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.messages.LocalizedMessageProvider;
import com.sap.cds.services.runtime.AuthenticationInfoProvider;
import com.sap.cds.services.runtime.CdsModelProvider;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;
import com.sap.cds.services.runtime.ParameterInfoProvider;
import com.sap.cds.services.runtime.UserInfoProvider;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class CdsRuntimeInitializer
implements InitializingBean,
ApplicationContextAware {
    @Autowired
    private CdsRuntimeConfigurer configurer;
    @Autowired
    private List<Service> services;
    @Autowired(required=false)
    private List<UserInfoProvider> userProviders;
    @Autowired(required=false)
    private List<AuthenticationInfoProvider> authenticationInfoProviders;
    @Autowired(required=false)
    private List<ParameterInfoProvider> parameterProviders;
    @Autowired(required=false)
    private List<CdsModelProvider> modelProviders;
    @Autowired(required=false)
    private List<LocalizedMessageProvider> localizedMessageProviders;
    private ApplicationContext context;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        ServiceCatalog catalog = this.configurer.getCdsRuntime().getServiceCatalog();
        this.services.stream().filter(s -> catalog.getService(s.getName()) == null).forEach(arg_0 -> ((CdsRuntimeConfigurer)this.configurer).service(arg_0));
        this.configurer.eventHandlerConfigurations();
        Arrays.stream(this.context.getBeanNamesForType(EventHandler.class)).filter(name -> !name.startsWith("scopedTarget.")).map(arg_0 -> ((ApplicationContext)this.context).getType(arg_0)).distinct().forEach(handlerClass -> this.configurer.eventHandler(handlerClass, () -> this.context.getBean(handlerClass)));
        this.configurer.providerConfigurations();
        if (this.userProviders != null) {
            CdsRuntimeInitializer.reverse(this.userProviders.stream()).forEach(arg_0 -> ((CdsRuntimeConfigurer)this.configurer).provider(arg_0));
        }
        if (this.authenticationInfoProviders != null) {
            CdsRuntimeInitializer.reverse(this.authenticationInfoProviders.stream()).forEach(arg_0 -> ((CdsRuntimeConfigurer)this.configurer).provider(arg_0));
        }
        if (this.parameterProviders != null) {
            CdsRuntimeInitializer.reverse(this.parameterProviders.stream()).forEach(arg_0 -> ((CdsRuntimeConfigurer)this.configurer).provider(arg_0));
        }
        if (this.modelProviders != null) {
            CdsRuntimeInitializer.reverse(this.modelProviders.stream()).forEach(arg_0 -> ((CdsRuntimeConfigurer)this.configurer).provider(arg_0));
        }
        if (this.localizedMessageProviders != null) {
            CdsRuntimeInitializer.reverse(this.localizedMessageProviders.stream()).forEach(arg_0 -> ((CdsRuntimeConfigurer)this.configurer).provider(arg_0));
        }
        this.configurer.complete();
        catalog.getServices(ApplicationLifecycleService.class).forEach(as -> as.applicationPrepared());
    }

    private static <T> Stream<T> reverse(Stream<T> stream) {
        return stream.collect(Collector.of(() -> new ArrayDeque(), ArrayDeque::addFirst, (q1, q2) -> {
            q2.addAll(q1);
            return q2;
        }, new Collector.Characteristics[0])).stream();
    }
}

