/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.runtime;

import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.runtime.ParameterInfoProvider;
import com.sap.cds.services.utils.runtime.HttpParameterInfo;
import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Configuration
@ConditionalOnClass(value={RequestContextHolder.class})
public class SpringParameterInfoProvider {
    @Bean
    @Order(value=0x7FFFFFFF)
    public ParameterInfoProvider parameterInfoProvider() {
        return new ParameterInfoProvider(){

            public ParameterInfo get() {
                RequestAttributes reqAttrs = RequestContextHolder.getRequestAttributes();
                if (reqAttrs != null && reqAttrs instanceof ServletRequestAttributes) {
                    HttpServletRequest httpRequest = ((ServletRequestAttributes)reqAttrs).getRequest();
                    return HttpParameterInfo.fromRequest((HttpServletRequest)httpRequest);
                }
                return null;
            }
        };
    }
}

