/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.servicedescriptor;

import com.sap.cds.feature.services.db.DataSourceDescriptor;
import com.sap.cds.feature.services.db.DataSourceProvider;
import com.sap.cds.feature.services.util.DataSourceProviderUtils;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.util.Optional;
import javax.sql.DataSource;
import org.springframework.beans.factory.FactoryBean;

public class DataSourceConnector
implements FactoryBean<DataSource> {
    private final DataSourceDescriptor descriptor;
    private final CdsRuntime runtime;
    private DataSource dataSource;

    public DataSourceConnector(DataSourceDescriptor descriptor, CdsRuntime runtime) {
        this.descriptor = descriptor;
        this.runtime = runtime;
    }

    public DataSource getObject() throws Exception {
        if (this.dataSource == null) {
            Optional provider = DataSourceProviderUtils.getDataSourceProvider((DataSourceDescriptor)this.descriptor, (CdsRuntime)this.runtime);
            this.dataSource = ((DataSourceProvider)provider.orElseThrow(() -> new ErrorStatusException((ErrorStatus)CdsErrorStatuses.NO_DATA_SOURCE_PROVIDER, new Object[]{this.descriptor.getName()}))).create(this.descriptor);
        }
        return this.dataSource;
    }

    public Class<?> getObjectType() {
        return this.descriptor.getConnectedType();
    }
}

