/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.servicedescriptor;

import com.sap.cds.feature.services.db.DataSourceDescriptor;
import com.sap.cds.feature.services.db.DataSourceProvider;
import com.sap.cds.feature.services.util.DataSourceProviderUtils;
import com.sap.cds.framework.spring.utils.SpringObjects;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.core.env.Environment;

public class SpringDataSourceProvider
implements DataSourceProvider {
    public DataSource create(DataSourceDescriptor descriptor) {
        DataSourceBuilder builder = DataSourceBuilder.create();
        builder.driverClassName(descriptor.getDriverClassName());
        builder.url(descriptor.getUrl());
        builder.username(descriptor.getUsername());
        builder.password(descriptor.getPassword());
        DataSource ds = builder.build();
        Binder binder = Binder.get((Environment)SpringObjects.getEnvironment());
        Bindable bindableDs = Bindable.ofInstance((Object)ds);
        for (String section : SpringDataSourceProvider.getDataSourceSections(descriptor)) {
            BindResult bindResult = binder.bind(section, bindableDs);
            if (!bindResult.isBound()) continue;
            return (DataSource)bindResult.get();
        }
        return ds;
    }

    private static List<String> getDataSourceSections(DataSourceDescriptor descriptor) {
        return Arrays.asList(DataSourceProviderUtils.getDataSourceSection((DataSourceDescriptor)descriptor, (DataSourceProviderUtils.PoolType)DataSourceProviderUtils.PoolType.HIKARI), DataSourceProviderUtils.getDataSourceSection((DataSourceDescriptor)descriptor, (DataSourceProviderUtils.PoolType)DataSourceProviderUtils.PoolType.TOMCAT), DataSourceProviderUtils.getDataSourceSection((DataSourceDescriptor)descriptor, (DataSourceProviderUtils.PoolType)DataSourceProviderUtils.PoolType.DBCP2));
    }

    public boolean accept(DataSourceDescriptor descriptor) {
        return descriptor.getDriverClassName() != null;
    }
}

