/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.framework.spring.config.datasource;

import javax.sql.DataSource;

import org.springframework.beans.factory.FactoryBean;

/**
 * Factory bean to create a {@link DataSource}
 */
public class SimpleDataSourceBeanFactory implements FactoryBean<DataSource> {

	private final DataSource bean;

	public SimpleDataSourceBeanFactory(DataSource bean) {
		this.bean = bean;
	}

	@Override
	public DataSource getObject() throws Exception {
		return bean;
	}

	@Override
	public Class<? extends DataSource> getObjectType() {
		return bean.getClass();
	}

}
