/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.framework.spring.config.runtime;

import org.springframework.beans.factory.FactoryBean;

import com.sap.cds.services.runtime.CdsRuntime;

/**
 * Factory bean to create a {@link CdsRuntime}
 */
public class SimpleCdsRuntimeBeanFactory implements FactoryBean<CdsRuntime> {

	private final CdsRuntime bean;

	public SimpleCdsRuntimeBeanFactory(CdsRuntime bean) {
		this.bean = bean;
	}

	@Override
	public CdsRuntime getObject() throws Exception {
		return bean;
	}

	@Override
	public Class<? extends CdsRuntime> getObjectType() {
		return bean.getClass();
	}

}
