/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.framework.spring.config.runtime;

import org.springframework.beans.factory.FactoryBean;

import com.sap.cds.services.runtime.CdsRuntimeConfigurer;

/**
 * Factory bean to create a {@link CdsRuntimeConfigurer}
 */
public class SimpleCdsRuntimeConfigurerBeanFactory implements FactoryBean<CdsRuntimeConfigurer> {

	private final CdsRuntimeConfigurer bean;

	public SimpleCdsRuntimeConfigurerBeanFactory(CdsRuntimeConfigurer bean) {
		this.bean = bean;
	}

	@Override
	public CdsRuntimeConfigurer getObject() throws Exception {
		return bean;
	}

	@Override
	public Class<? extends CdsRuntimeConfigurer> getObjectType() {
		return bean.getClass();
	}

}
