/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.framework.spring.config.runtime;

import org.springframework.beans.factory.FactoryBean;

import com.sap.cds.services.Service;

/**
 * Factory bean to create a {@link Service}
 */
public class SimpleServiceBeanFactory implements FactoryBean<Service> {

	private final Service bean;

	public SimpleServiceBeanFactory(Service bean) {
		this.bean = bean;
	}

	@Override
	public Service getObject() throws Exception {
		return bean;
	}

	@Override
	public Class<? extends Service> getObjectType() {
		return bean.getClass();
	}

}
